// Copyright 1997-2003 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//

#import <Foundation/NSGeometry.h>

@class NSBundle, NSArray, NSMutableArray, NSMutableDictionary;
@class NSBox, NSButton, NSImageView, NSMatrix, NSTabView, NSTextField, NSToolbar, NSView, NSWindow;
@class OAPreferenceClient, OAPreferenceClientRecord, OAPreferencesIconView, OAPreferencesShowAllIconView, OAPreferencesWindow;
@class OAPreferencesMultipleIconView;
@class NSPrintInfo;

#import <AppKit/NSApplication.h>
#import <AppKit/NSNibDeclarations.h> // For IBOutlet

typedef enum OAPreferencesViewStyle {
        OAPreferencesViewSingle = 0, // one client, so no navigation bar
        OAPreferencesViewMultiple = 1, // several clients, presented a la Mail or Terminal
        OAPreferencesViewCustomizable = 2 // many clients in one or more categories, presented a la System Prefs. 
} OAPreferencesViewStyle;

@interface OAPreferenceController : NSObject
{
    IBOutlet OAPreferencesWindow *window;
    IBOutlet NSBox *preferenceBox;
    IBOutlet NSView *globalControlsView;
    IBOutlet NSButton *helpButton;
    IBOutlet NSButton *returnToOriginalValuesButton;
    
    NSView *showAllIconsView; // not to be confused with the "Show All" button
    OAPreferencesIconView *multipleIconView;
    
    NSMutableArray *preferencesIconViews;
    NSMutableDictionary *categoryNamesToClientRecordsArrays;
    NSMutableDictionary *localizedCategoryNames;
    NSMutableDictionary *categoryPriorities;
    
    NSMutableArray *allClientRecords;

    OAPreferencesViewStyle viewStyle;
    
    NSToolbar *toolbar;
    NSArray *defaultToolbarItems;
    NSArray *allowedToolbarItems;

    OAPreferenceClientRecord *nonretained_currentClientRecord;
    OAPreferenceClient *nonretained_currentClient;
	
	NSMutableArray		*preRegisteredClientNames;
	
	NSPrintInfo			*_pInfo;
	
}



+ (OAPreferenceController *)sharedPreferenceController;

// API

/*!
	@method preRegisterPreferenceClientWithName:
	@discussion Used to register clients by name. Clients aren't loaded until the interface is first called. If the interface is already loaded, calls registerPreferenceClientWithName: directly.
	@param aName - the name of a client (a subclass of OAPreferenceClient)
*/
- (void)preRegisterPreferenceClientWithName:(NSString *)aName;

- (void)registerPreferenceClientWithName:(NSString *)className;
- (void)registerPreferenceClientWithName:(NSString *)itemName 
	bundle:(NSBundle *)bundle 
	description:(NSDictionary *)description;


- (void)refreshLayout;

- (void)close;
- (NSWindow *)window;
- (void)setTitle:(NSString *)title;
- (void)setCurrentClientByClassName:(NSString *)name;
- (void)setCurrentClientByTag:(int)tag;
- (NSArray *)allClientRecords;
- (OAPreferenceClientRecord *)clientRecordWithShortTitle:(NSString *)shortTitle;
- (OAPreferenceClientRecord *)clientRecordWithIdentifier:(NSString *)identifier;
- (OAPreferenceClient *)clientWithShortTitle:(NSString *)shortTitle;
- (OAPreferenceClient *)clientWithIdentifier:(NSString *)identifier;
- (void)iconView:(OAPreferencesIconView *)iconView buttonHitAtIndex:(unsigned int)index;

- (NSPrintInfo *)printInfo;
- (void)setPrintInfo:(NSPrintInfo *)info;
- (void)showAllIcons:(id)sender;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)restoreDefaults:(id)sender;
- (IBAction)showNextClient:(id)sender;
- (IBAction)showPreviousClient:(id)sender;
- (IBAction)setCurrentClientFromToolbarItem:(id)sender;
- (IBAction)showHelpForClient:(id)sender;

- (OAPreferenceClientRecord *)showClientWithIdentifier:(NSString *)ident;
- (OAPreferenceClient *)preferenceClientWithIdentifier:(NSString *)ident;

@end

@interface NSApplication (PreferencesAdditions)

/*!
	@method showPreferences:
	@discussion shows the preferences panel
*/
- (IBAction)showPreferences:(id)sender;

@end

@interface NSApplication (MCApplicationAdditions)
- (void)showHelpURL:(NSString *)aHelpURL;
@end

